<?php 
	include("header.php");
	

$date1 = gmdate("l jS \of F Y h:i:s A");

$output = ""; // Initialize output for validation errors

if (isset($_POST['form_submit'])) {
    // Sanitize inputs
    $user_name = filter_var($_POST["form_name"], FILTER_SANITIZE_SPECIAL_CHARS);
    $mno = isset($_POST["form_phone"]) ? $_POST["form_phone"] : "";
    $user_email = filter_var($_POST["form_email"], FILTER_SANITIZE_EMAIL);
    $user_subject = filter_var($_POST["form_subject"], FILTER_SANITIZE_SPECIAL_CHARS);
    $message = filter_var($_POST["form_message"], FILTER_SANITIZE_SPECIAL_CHARS);

    // Validation errors array
    $errors = [];

    // Validate fields
    if (empty($user_name)) {
        $errors[] = "The <b>Name</b> field is required.";
    }
    if (empty($mno)) {
        $errors[] = "The <b>Phone Number</b> field is required.";
    } elseif (!preg_match("/^\+?[0-9]{7,15}$/", $mno)) {
        $errors[] = "The <b>Phone Number</b> is invalid. It should be 7-15 digits and may include a '+' at the start.";
    }
    if (empty($user_email)) {
        $errors[] = "The <b>Email</b> field is required.";
    } elseif (!filter_var($user_email, FILTER_VALIDATE_EMAIL)) {
        $errors[] = "The <b>Email</b> address is invalid.";
    }
    if (empty($user_subject)) {
        $errors[] = "The <b>Subject</b> field is required.";
    }
    if (empty($message)) {
        $errors[] = "The <b>Message</b> field is required.";
    }

    // Check for errors
    if (!empty($errors)) {
        $output .= '<div class="alert alert-danger alert-dismissible fade show" role="alert">';
        $output .= '<strong>Please fix the following errors:</strong>';
        $output .= '<ul class="mb-0" style="list-style-type: disc; padding-left: 20px;">'; // Ensures dot list style
        foreach ($errors as $error) {
            $output .= '<li style="list-style:auto;">' . $error . '</li>';
        }
        $output .= '</ul>';
        $output .= '<button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>';
        $output .= '</div>';
    } else {
        // Proceed with email sending if no errors
        $toEmail = "info@blueprint360.co.in";
        $mailHeaders = "Content-type:text/html;charset=UTF-8" . "\r\n";
        $mailHeaders .= "From: " . $user_name . "<" . $user_email . ">\r\n";

        $mailBody = "IP Address&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; :" . $_SERVER['REMOTE_ADDR'] . "<br>";
        $mailBody .= "Name&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; : " . $user_name . "<br>";
        $mailBody .= "PhoneNumber&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; : " . $mno . "<br>";
        $mailBody .= "Email&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;: " . $user_email . "<br>";
        $mailBody .= "Message&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; : " . $message . "<br>";
        $mailBody .= "Date and Time&nbsp;&nbsp; : " . $date1 . "\n";

        if (mail($toEmail, $user_subject, $mailBody, $mailHeaders)) {
            $output = '<div class="alert alert-success alert-dismissible fade show" role="alert">';
            $output .= '<strong>Success!</strong> Hi ' . htmlspecialchars($user_name) . ', Thank you for contacting us. We will get back to you shortly.';
            $output .= '<button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>';
            $output .= '</div>';
            
            $_POST = []; // Clear the form inputs
        } else {
            $output = '<div class="alert alert-danger alert-dismissible fade show" role="alert">';
            $output .= '<strong>Error!</strong> Unable to send email, please try again.';
            $output .= '<button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>';
            $output .= '</div>';
        }

    }
}

?>
	<!--End Main Header -->

	<!-- Start main-content -->
	<!-- <section class="page-title" style="background-image: url(images/background/page-title.jpg);">
		<div class="auto-container">
			<div class="title-outer">
				<h1 class="title">Contact Us</h1>
				<ul class="page-breadcrumb">
					<li><a href="index.php">Home</a></li>
					<li>Contact Us</li>
				</ul>
			</div>
		</div>
	</section> -->
	<!-- end main-content -->

	<!--Contact Details Start-->
	<section class="contact-details">
		<div class="container ">
			<div class="row align-items-center">
				<div class="col-xl-7 col-lg-6">
					<div class="sec-title">
						<span class="sub-title">Send us an email</span>
						<h2>Get In Touch With Us</h2>
					</div>
					<!-- Contact Form -->
					<?php echo isset($output)? $output : ""; ?>
					<form id="contact_form" name="contact_form" class="" action="" method="post">
						<div class="row">
							<div class="col-sm-6">
								<div class="mb-3">
									<input name="form_name" value="<?php echo isset($_POST["form_name"]) ? $_POST["form_name"] : ""; ?>" class="form-control" type="text" placeholder="Name" required>
								</div>
							</div>
							<div class="col-sm-6">
								<div class="mb-3">
									<input name="form_email" value="<?php echo isset($_POST["form_email"]) ? $_POST["form_email"] : ""; ?>" class="form-control required email" type="email" placeholder="Email Address" required>
								</div>
							</div>
						</div>
						<div class="row">
							<div class="col-sm-6">
								<div class="mb-3">
									<input name="form_subject" value="<?php echo isset($_POST["form_subject"]) ? $_POST["form_subject"] : ""; ?>" class="form-control required" type="text" placeholder="Subject" required>
								</div>
							</div>
							<div class="col-sm-6">
								<div class="mb-3">
									<input name="form_phone" value="<?php echo isset($_POST["form_phone"]) ? $_POST["form_phone"] : ""; ?>" class="form-control" type="number" placeholder="Phone Number" required>
								</div>
							</div>
						</div>
						<div class="mb-3">
							<textarea name="form_message" class="form-control required" rows="7" placeholder="Message" required><?php echo isset($_POST["form_message"]) ? $_POST["form_message"] : ""; ?></textarea>
						</div>
						<div class="mb-3">
							<input name="form_botcheck" class="form-control" type="hidden" value="" />
							<button type="submit" name="form_submit" class="theme-btn btn-style-one" data-loading-text="Please wait..."><span class="btn-title">Submit</span></button>
						</div>
					</form>
					<!-- Contact Form Validation-->
				</div>
				<div class="col-xl-5 col-lg-6">
					<div class="contact-details__right">
						<!-- <div class="sec-title">
							<span class="sub-title">Need any help?</span>
							<h2>Get in touch with us</h2>
							<div class="text">We're here to help! Contact us to discuss your needs and explore how our solutions can benefit you.</div>
						</div> -->
						<ul class="list-unstyled contact-details__info">
							<li>
								<div class="icon bg-theme-color2">
									<span class="lnr-icon-phone-plus"></span>
								</div>
								<div class="text">
									<h6>Have Any Questions?</h6>
									<a href="tel:+91 984 109 6575"><span>Call Us</span> +91 984 109 6575</a>
								</div>
							</li>
							<li>
								<div class="icon">
									<span class="lnr-icon-envelope1"></span>
								</div>
								<div class="text">
									<h6>Write Email</h6>
									<a href="mailto:blueprint360@gmail.com">blueprint360@gmail.com</a>
									<a href="mailto:info@blueprint360.co.in">info@blueprint360.co.in</a>
								</div>
							</li>
							<li>
								<div class="icon">
									<span class="lnr-icon-location"></span>
								</div>
								<div class="text">
									<h6>Visit Us</h6>
									<span>Blueprint360, No 43/22 Josier street, No 303 3rd floor, Real enclave<br> 
			Nungambakkam, Chennai - 600034 (Near Vinitha Hospital)</span>
								</div>
							</li>
						</ul>
					</div>
				</div>
			</div>
		</div>
	</section>
	<!--Contact Details End-->

	<!-- Map Section-->
	<section class="map-section">
		<iframe src="https://www.google.com/maps/embed?pb=!1m18!1m12!1m3!1d4767.307164657982!2d80.24292287590099!3d13.053374187269558!2m3!1f0!2f0!3f0!3m2!1i1024!2i768!4f13.1!3m3!1m2!1s0x3a5266437a90436f%3A0xe96c7058a94caf00!2sNo%20303%203rd%20floor%2C%20Real%20Enclave%2C%2022%2C%20Josier%20St%2C%20Tirumurthy%20Nagar%2C%20Nungambakkam%2C%20Chennai%2C%20Tamil%20Nadu%20600034!5e1!3m2!1sen!2sin!4v1733316304917!5m2!1sen!2sin" width="100%" height="450" style="border:0;" allowfullscreen="" loading="lazy" referrerpolicy="no-referrer-when-downgrade"></iframe>
	</section>
	<!--End Map Section-->

  <!-- Main Footer -->
	<?php include("footer.php"); ?>